﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.UserInterface
{
    public class UIButton : UIText, IButton
    {
        private Color _highlightColor;
        
        public Color HighlightColor
        {
            get { return _highlightColor; }
            set { _highlightColor = value; }
        }

        public UIButton(string text, Color highlightColor):base(text)
        {
            _highlightColor = highlightColor;
        }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            if (WidgetState == 2)
            {
                OnCallback();
            }
        }

        public override void Draw(SpriteBatch spriteBatch)
        {
            if (WidgetState == 0)
            {
                base.Draw(spriteBatch);
            }
            else if (WidgetState >= 1)
            {
                spriteBatch.DrawString(Font, Text, Position, HighlightColor);
            }
        }



        #region IPressable Members

        public void OnPressed()
        {
            ParentUI.WidgetCallback(this);
        }

        #endregion
    }
}
